#ifndef GST_CU_CONSTRAINED_COLOR_VALUE_DESC_HPP__
#define GST_CU_CONSTRAINED_COLOR_VALUE_DESC_HPP__

#include "buildspec.h"

#include "Client/ClientUtils/Network/constrained_color_column_desc.hpp"

#include <string>

namespace GST
{
namespace ClientUtils
{
// Describes the columns that build a constrained color map
class GST_API_EXPORT ConstrainedColorValueDesc
{
public:
	// columns for a continuous constrained color map
	// value must be of type integer or float
	// label must be of type text
	ConstrainedColorValueDesc(std::string table,
							  ConstrainedColorColumnDesc colorColumns,
							  std::string valueColumn,
							  std::string labelColumn);
	// columns for a discrete constrained color map
	// value must be of type bool, integer, float or string
	// label must be of type text
	// order must be of type integer
	ConstrainedColorValueDesc(std::string table,
							  ConstrainedColorColumnDesc colorColumns,
							  std::string valueColumn,
							  std::string labelColumn,
							  std::string orderColumn);
	// get the type of column description
	bool isDiscrete() const;
	bool isContinuous() const;
	// returns the table info
	const std::string &table() const;
	// returns the color column info
	const ConstrainedColorColumnDesc &colorColumns() const;
	// returns the order, label and order column names.
	// Order might be empty if not set. See `isDiscrete` for if it is active
	const std::string &valueColumn() const;
	const std::string &labelColumn() const;
	const std::string &orderColumn() const;

private:
	std::string m_table;
	ConstrainedColorColumnDesc m_colorColumns;
	std::string m_valueColumn;
	std::string m_labelColumn;
	std::string m_orderColumn;
	bool m_isDiscrete;
};

} // namespace ClientUtils
} // namespace GST
#endif // GST_CU_CONSTRAINED_COLOR_VALUE_DESC_HPP__
